
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

// Referenced classes of package duggelz.jape:
//            InsetPanel

public class JapeAbout extends Dialog
{

    public JapeAbout(Frame parent)
    {
        super(parent, "ber JAPE", true);
        Panel body = new Panel();
        body.setLayout(new BorderLayout());
        add(body);
        Panel textPanel = new InsetPanel(5, 5, 5, 5);
        textPanel.setLayout(new GridLayout(3, 1));
        textPanel.setBackground(SystemColor.text);
        Label line1 = new Label("JAPE: A Jagged Alliance 2 Save Game Editor", 1);
        textPanel.add(line1);
        Label line2 = new Label("Version 0.32", 1);
        textPanel.add(line2);
        Label line3 = new Label("Copyright (c) 1999  Douglas Greiman", 1);
        textPanel.add(line3);
        Label line4 = new Label("Deutsch Portierung von Bernd Leitenberger", 1);
        textPanel.add(line4);
        Panel buttonPanel = new InsetPanel(0, 5, 0, 5);
        buttonPanel.setLayout(new FlowLayout());
        Button okButton = new Button("OK");
        okButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e)
            {
                dispose();
            }

        });
        buttonPanel.add(okButton);
        body.add(buttonPanel, "South");
        body.add(textPanel, "Center");
        addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent e)
            {
                dispose();
            }

        });
        addNotify();
        pack();
        if(parent != null)
        {
            Point parentLoc = parent.getLocation();
            Dimension parentSize = parent.getSize();
            Dimension size = getSize();
            Point loc = new Point(parentLoc.x + (parentSize.width - size.width) / 2, parentLoc.y + (parentSize.height - size.height) / 2);
            setLocation(loc);
        }
    }
}
